% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.kl.r
\name{metric.kl}
\alias{metric.kl}
\title{Kullback--Leibler distance}
\usage{
metric.kl(fdata1, fdata2 = NULL, symm = TRUE, base = exp(1),
  eps = 1e-10, ...)
}
\arguments{
\item{fdata1}{Functional data 1 (\code{fdata} class) with the densities. The
dimension of \code{fdata1} object is (\code{n1} x \code{m}), where \code{n1}
is the number of densities and \code{m} is the number of coordinates of the
points where the density is observed.}

\item{fdata2}{Functional data 2 (\code{fdata} class) with the densities. The
dimension of \code{fdata2} object is (\code{n2} x \code{m}).}

\item{symm}{If \code{TRUE} the symmetric K--L distance is computed, see
details section.}

\item{base}{The logarithm base used to compute the distance.}

\item{eps}{Tolerance value.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\description{
Measures the proximity between two groups of densities (of class
\code{fdata}) by computing the Kullback--Leibler distance.
}
\details{
Kullback--Leibler distance between \eqn{f(t)}{f(t)} and \eqn{g(t)}{g(t)} is
\deqn{metric.kl(f(t),g(t))= \int_{a}^{b} {f(t) log\left(\frac{f(t)}{g(t)}\right)dt}}{dist(f(t),g(t))= \int_{a}^{b} f(t)*
log(f(t)/g(t)) dt} where \eqn{t} are the \code{m} coordinates of the points
where the density is observed (the \code{argvals} of the \code{fdata} object).

The Kullback--Leibler distance is asymmetric, 
\deqn{metric.kl(f(t),g(t))\neq metric.kl(g(t),f(t))}{dist(f(t),g(t))!=dist(g(t),f(t))}
 A symmetry version of K--L distance (by default) can be obtained by
\deqn{0.5\left(metric.kl(f(t),g(t))+metric.kl(g(t),f(t))\right)}{0.5*(dist(f(t),g(t))+dist(g(t),f(t)))}

If \eqn{\left(f_i(t)=0\ \& \ g_j(t)=0\right) \Longrightarrow
metric.kl(f(t),g(t))=0}{(f(t)=0 and g(t)=0), then metric.kl(f(t),g(t))=0}.

If \eqn{\left|f_i(t)\-g_i(t) \right|\leq \epsilon \Longrightarrow
f_i(t)=f_i(t)+\epsilon}{abs(f(t)-g(t))<\epsilon, then f(t)=f(t)+\epsilon},
where \eqn{\epsilon} is the tolerance value (by default \code{eps=1e-10}).

The coordinates of the points where the density is observed (discretization
points \eqn{t}) can be equally spaced (by default) or not.
}
\examples{
\dontrun{   
n<-201                                                                                       
tt01<-seq(0,1,len=n)                                                                         
rtt01<-c(0,1)  
x1<-dbeta(tt01,20,5)                                                                           
x2<-dbeta(tt01,21,5)                                                                           
y1<-dbeta(tt01,5,20)                                                                           
y2<-dbeta(tt01,5,21)                                                                           
xy<-fdata(rbind(x1,x2,y1,y2),tt01,rtt01)
plot(xy)
round(metric.kl(xy,xy,eps=1e-5),6)  
round(metric.kl(xy,eps=1e-5),6)
round(metric.kl(xy,eps=1e-6),6)
round(metric.kl(xy,xy,symm=FALSE,eps=1e-5),6)  
round(metric.kl(xy,symm=FALSE,eps=1e-5),6)

plot(c(fdata(y1[1:101]),fdata(y2[1:101])))                       
metric.kl(fdata(x1))  
metric.kl(fdata(x1),fdata(x2),eps=1e-5,symm=F)       
metric.kl(fdata(x1),fdata(x2),eps=1e-6,symm=F)       
metric.kl(fdata(y1[1:101]),fdata(y2[1:101]),eps=1e-13,symm=F)  
metric.kl(fdata(y1[1:101]),fdata(y2[1:101]),eps=1e-14,symm=F)  
}   

}
\references{
Kullback, S., Leibler, R.A. (1951). \emph{On information and
sufficiency.} Annals of Mathematical Statistics, 22: 79-86
}
\seealso{
See also \code{\link{metric.lp}} and \code{\link{fdata}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{cluster}
