% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.omit.fdata.R
\name{na.omit.fdata}
\alias{na.omit.fdata}
\alias{na.fail.fdata}
\title{A wrapper for the na.omit and na.fail function for fdata object}
\usage{
\method{na.omit}{fdata}(object, ...)

\method{na.fail}{fdata}(object, ...)
}
\arguments{
\item{object}{an \code{fdata} object.}

\item{\dots}{further potential arguments passed to methods.}
}
\value{
The value returned from \code{omit} is a \code{fdata} object with incomplete cases removed.
}
\description{
\code{na.fail} returns the object if it does not contain any 
missing values, and signals an error otherwise. \code{na.omit} returns the object
with incomplete cases removed.
If \code{na.omit.fdata} removes cases, the row numbers of the cases form the 
\code{"na.action"} attribute of the result, of class \code{"omit"}, see generic 
function \code{\link{na.omit}}.
}
\examples{
\dontrun{
fdataobj<-fdata(MontrealTemp)
fdataobj$data[3,3]<-NA
fdataobj$data[10,]<-NA
fdastaobj2<-na.omit(fdataobj)
} 

}
\author{
Manuel Febrero Bande and Manuel Oviedo
}
\keyword{descriptive}
