% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fregre.basis.R
\name{fregre.basis}
\alias{fregre.basis}
\title{Functional Regression with scalar response using basis representation.}
\usage{
fregre.basis(
  fdataobj,
  y,
  basis.x = NULL,
  basis.b = NULL,
  lambda = 0,
  Lfdobj = vec2Lfd(c(0, 0), rtt),
  weights = rep(1, n),
  ...
)
}
\arguments{
\item{fdataobj}{\code{\link{fdata}} class object.}

\item{y}{Scalar response with length \code{n}.}

\item{basis.x}{Basis for functional explanatory data \code{fdataobj}.}

\item{basis.b}{Basis for functional beta parameter.}

\item{lambda}{A roughness penalty. By default, no penalty \code{lambda=0}.}

\item{Lfdobj}{See \link[fda]{eval.penalty}.}

\item{weights}{weights}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return:
\itemize{
\item {call}{ The matched call.} 
\item {coefficients}{ A named vector of coefficients}
\item {residuals}{ \code{y} minus \code{fitted values}.} 
\item {fitted.values}{ Estimated scalar response.} 
\item {beta.est}{ beta parameter estimated of class \code{fd}} 
\item {weights}{(only for' weighted fits) the specified weights.} 
\item {df}{ The residual degrees of' freedom.} 
\item {r2}{ Coefficient of determination.} 
\item {sr2}{ Residual' variance.} 
\item {Vp}{ Estimated covariance matrix for the parameters.}
\item {H}{ Hat matrix.} 
\item {y}{ Response.}
\item {fdataobj}{ Functional explanatory data of class \code{fdata}.}
\item {a.est}{ Intercept parameter estimated} 
\item {x.fd}{ Centered functional explanatory data of class \code{fd}.} 
\item {basis.b}{ Basis used' for beta parameter estimation.} 
\item {lambda.opt}{ A roughness penalty.}
\item {Lfdobj}{ Order of a derivative or a linear differential operator.}
\item {P}{ Penalty matrix.} 
\item {lm}{ Return \code{lm} object }
}
}
\description{
Computes functional regression between functional explanatory variable
\eqn{X(t)} and scalar response \eqn{Y} using basis representation.
}
\details{
\deqn{Y=\big<X,\beta\big>+\epsilon=\int_{T}{X(t)\beta(t)dt+\epsilon}}{Y=<X,\beta>+\epsilon} 
where \eqn{ \big< \cdot , \cdot \big>}{<.,.>} denotes the inner product on
\eqn{L_2} and \eqn{\epsilon} are random errors with mean zero, finite
variance \eqn{\sigma^2} and \eqn{E[X(t)\epsilon]=0}{E[X(t)\epsilon]=0}.

The function uses the basis representation proposed by Ramsay and Silverman (2005) to model the
relationship between the scalar response and the functional covariate by
basis representation of the observed functional data
\eqn{X(t)\approx\sum_{k=1}^{k_{n1}} c_k \xi_k(t)}{X(t)} and the unknown
functional parameter \eqn{\beta(t)\approx\sum_{k=1}^{k_{n2}} b_k
\phi_k(t)}{\beta(t)}. \cr

The functional linear models estimated by the expression: \deqn{\hat{y}=
\big< X,\hat{\beta} \big> =
C^{T}\psi(t)\phi^{T}(t)\hat{b}=\tilde{X}\hat{b}}{y.est= < X,\beta.est > =
C'\psi\phi' \beta.est=Z\beta.est} where
\eqn{\tilde{X}(t)=C^{T}\psi(t)\phi^{T}(t)}{Z=C'\psi\phi'}, and
\eqn{\hat{b}=(\tilde{X}^{T}\tilde{X})^{-1}\tilde{X}^{T}y}{\beta.est=(Z'Z)^{-1}Z'y}
and so,
\eqn{\hat{y}=\tilde{X}\hat{b}=\tilde{X}(\tilde{X}^{T}\tilde{X})^{-1}\tilde{X}^{T}y=Hy}{y.est=Z(Z'Z)^{-1}Z'y}
where \eqn{H} is the hat matrix with degrees of freedom: \eqn{df=tr(H)}.\cr

If \eqn{\lambda>0}{\lambda>0} then \code{fregre.basis} incorporates a
roughness penalty: \cr
\eqn{\hat{y}=\tilde{X}\hat{b}=\tilde{X}(\tilde{X}^{T}\tilde{X}+\lambda
R_0)^{-1}\tilde{X}^{T}y= H_{\lambda}y}{y.est=Z(Z'Z+\lambda R_0)^{-1} Z'y=
H_{\lambda}y} where \eqn{R_0} is the penalty matrix.\cr

This function allows covariates of class \code{fdata}, \code{matrix},
\code{data.frame} or directly covariates of class \code{fd}.  The function
also gives default values to arguments \code{basis.x} and \code{basis.b} for
representation on the basis of functional data \eqn{X(t)} and the functional
parameter \eqn{\beta(t)}, respectively.

If \code{basis=}\code{NULL} creates the \code{bspline} basis by
\code{\link{create.bspline.basis}}. \cr If the functional covariate
\code{fdataobj} is a matrix or data.frame, it creates an object of class
"fdata" with default attributes, see \code{\link{fdata}}.\cr If
\code{basis.x$type=``fourier''} and \code{basis.b$type=``fourier''}, the
basis are orthonormal and the function decreases the number of fourier basis
elements on the \eqn{min(k_{n1},k_{n2})}{min(k.x,k_b)}, where
\eqn{k_{n1}}{k.x} and \eqn{k_{n2}}{k.b} are the number of basis element of
\code{basis.x} and \code{basis.b} respectively.
}
\examples{
\dontrun{
# fregre.basis
data(tecator)
names(tecator)
absorp=tecator$absorp.fdata
ind=1:129
x=absorp[ind,]
y=tecator$y$Fat[ind]
tt=absorp[["argvals"]]
res1=fregre.basis(x,y)
summary(res1)
basis1=create.bspline.basis(rangeval=range(tt),nbasis=19)
basis2=create.bspline.basis(rangeval=range(tt),nbasis=9)
res5=fregre.basis(x,y,basis1,basis2)
summary(res5)
x.d2=fdata.deriv(x,nbasis=19,nderiv=1,method="bspline",class.out="fdata")
res7=fregre.basis(x.d2,y,basis1,basis2)
summary(res7)
}
}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{
Functional Data Analysis}, 2nd ed., Springer, New York.

Febrero-Bande, M., Oviedo de la Fuente, M. (2012).  \emph{Statistical
Computing in Functional Data Analysis: The R Package fda.usc.} Journal of
Statistical Software, 51(4), 1-28. \url{http://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as: \code{\link{fregre.basis.cv}},
\code{\link{summary.fregre.fd}} and \code{\link{predict.fregre.fd}}.\cr
Alternative method: \code{\link{fregre.pc}} and \code{\link{fregre.np}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{regression}
