% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fdaPDE.objects.R
\name{FEM}
\alias{FEM}
\title{Define a surface or spatial field by a Finite Element basis expansion}
\usage{
FEM(coeff,FEMbasis)
}
\arguments{
\item{coeff}{A vector or a matrix containing the coefficients for the Finite Element basis expansion. The number of rows
(or the vector's length) corresponds to the number of basis in \code{FEMbasis}.
The number of columns corresponds to the number of functional replicates.}

\item{FEMbasis}{A \code{FEMbasis} object defining the Finite Element basis, created by \link{create.FEM.basis}.}
}
\value{
An \code{FEM} object. This contains a list with components \code{coeff} and \code{FEMbasis}.
}
\description{
This function defines a FEM object. This is not usualled called directly by users.
}
\examples{
## Upload a triangular mesh and plot it
data("mesh.2D.rectangular")
plot(mesh.2D.rectangular)
## Create a linear Finite Element basis
FEMbasis = create.FEM.basis(mesh.2D.rectangular, 1)
## Define a sinusoidal function as expansion of this basis and plot it
coeff <- sin(mesh.2D.rectangular$nodes[,1])*cos(mesh.2D.rectangular$nodes[,2])
FEM_object<- FEM(coeff, FEMbasis)
plot(FEM_object)
}

