% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreatePathPlot.R
\name{CreatePathPlot}
\alias{CreatePathPlot}
\title{Create the fitted sample path plot based on the results from FPCA().}
\usage{
CreatePathPlot(fpcaObj, subset, k = NULL,
  inputData = fpcaObj[["inputData"]], showObs = !is.null(inputData),
  derOptns = NULL, ...)
}
\arguments{
\item{fpcaObj}{Returned object from FPCA().}

\item{subset}{A vector of indices or a logical vector for subsetting the
observations.}

\item{k}{The number of components to reconstruct the fitted sample paths.}

\item{inputData}{A list of length 2 containing the sparse/dense
(unsupported yet) observations. \code{inputData} needs to contain two
fields: \code{Lt} for a list of time points and \code{Ly} for a list of
observations. Default to the `inputData` field within `fpcaObj`.}

\item{showObs}{Whether to plot the original observations for each subject.}

\item{derOptns}{A list of options to control derivation parameters; see `fitted.FPCA'. (default = NULL)}

\item{...}{other arguments passed into matplot for plotting options}
}
\description{
Create the fitted sample path plot based on the results from FPCA().
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan',
            verbose=TRUE))
CreatePathPlot(res, subset=1:5)
}

