% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{TEXTMINING}
\alias{TEXTMINING}
\title{Text mining}
\usage{
TEXTMINING(corpus, miningmethod, vector = c("docs", "words"), ...)
}
\arguments{
\item{corpus}{The corpus.}

\item{miningmethod}{The data mining method.}

\item{vector}{Indicates the type of vecrtorization, documents (TF-IDF) or words (GloVe).}

\item{...}{Parameters passed to the vectorisation and to the data mining method.}
}
\value{
The result of the data mining method.
}
\description{
Apply data mining function on vectorized text
}
\examples{
\dontrun{
require (text2vec)
data ("movie_review")
d = movie_review [, 2:3]
d [, 1] = factor (d [, 1])
d = splitdata (d, 1)
model = TEXTMINING (d$train.x, NB, labels = d$train.y, mincount = 50)
pred = predict (model, d$test.x)
evaluation (pred, d$test.y)
text = loadtext ("http://mattmahoney.net/dc/text8.zip")
clusters = TEXTMINING (text, HCA, vector = "words", k = 9, maxwords = 100)
plotclus (clusters$res, text, type = "tree", labels = TRUE)
}
}
\seealso{
\code{\link{predict.textmining}}, \code{\link{textmining-class}}, \code{\link{vectorize.docs}}, \code{\link{vectorize.words}}
}
