% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{kmeans.getk}
\alias{kmeans.getk}
\title{Estimation of the number of clusters for \emph{K}-means}
\usage{
kmeans.getk(d, max = 9, criterion = "pseudo-F", graph = TRUE,
  nstart = 10, seed = NULL)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{max}{The maximum number of clusters. Values from 2 to \code{max} are evaluated.}

\item{criterion}{The criterion to be optimized. \code{"pseudo-F"} is the only criterion implemented in the current version.}

\item{graph}{A logical indicating whether or not a graphic should be plotted.}

\item{nstart}{The number of random sets chosen for \code{\link[stats]{kmeans}} initialization.}

\item{seed}{A specified seed for random number generation.}
}
\value{
The optimal number of cluster of the \emph{K}-means clustering method according to the chosen criterion.
}
\description{
Estimate the optimal number of cluster of the \emph{K}-means clustering method.
}
\examples{
require (datasets)
data (iris)
kmeans.getk (iris [, -5])
}
\seealso{
\code{\link{pseudoF}}, \code{\link[stats]{kmeans}}
}
