% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{confusion}
\alias{confusion}
\title{Confuion matrix}
\usage{
confusion(gt, pred, norm = TRUE, graph = TRUE)
}
\arguments{
\item{gt}{The ground truth.}

\item{pred}{The prediction.}

\item{norm}{Whether or not the confusion matrix is normalized}

\item{graph}{Whether or not a graphic is displayed.}
}
\value{
The confusion matrix.
}
\description{
Plot a confusion matrix.
}
\examples{
require ("datasets")
data (iris)
d = splitdata (iris, 5)
model = NB (d$train.x, d$train.y)
pred = predict (model, d$test.x)
confusion (d$test.y, pred)
}
\seealso{
\code{\link{evaluation}}, \code{\link{performance}}, \code{\link{splitdata}}
}
