% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{DBSCAN}
\alias{DBSCAN}
\title{DBSCAN clustering method}
\usage{
DBSCAN(d, minpts, epsilonDist, ...)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{minpts}{Reachability minimum no. of points.}

\item{epsilonDist}{Reachability distance.}

\item{...}{Other parameters.}
}
\value{
A clustering model obtained by DBSCAN.
}
\description{
Run the DBSCAN algorithm for clustering.
}
\examples{
require (datasets)
data (iris)
DBSCAN (iris [, -5], minpts = 5, epsilonDist = 1)
}
\seealso{
\code{\link[fpc]{dbscan}}, \code{\link{dbs-class}}, \code{\link{distplot}}, \code{\link{predict.dbs}}
}
