% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{feature_if}
\alias{feature_if}
\title{Evaluates the provided expression if the feature flag
is enabled.}
\usage{
feature_if(feature_flag, expr)
}
\arguments{
\item{feature_flag}{flag which defines whether the provided
expression should be evaluated}

\item{expr}{expression to evaluate when the feature_flag is enabled}
}
\value{
If the passed \code{feature_flag} is enabled, than the result of the evaluation
of the passed expression is returned. Otherwise there is no return value.
}
\description{
Evaluates the provided expression if the feature flag
is enabled.
}
\details{
The passed expression is evaluated in the frame where \code{feature_if}
is called.
}
\examples{
{
  flag <- create_bool_feature_flag(TRUE)

  feature_if(flag, {
    2 + 7
  })
}
}
