% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/febr2spdf.R
\name{febr2spdf}
\alias{febr2spdf}
\title{Create an object of class \code{SpatialPointsDataFrame}}
\usage{
febr2spdf(obj)
}
\arguments{
\item{obj}{Object of class \code{data.frame} downloaded from \emph{\strong{febr}} using function
\code{\link[febr]{observation}}.}
}
\value{
An object of class \code{SpatialPointsDataFrame}
}
\description{
Set spatial coordinates and projection attributes to create an object of class \code{SpatialPointsDataFrame} from
the \emph{observation} ("observacao") table of one or more standardized datasets contained in the Free Brazilian
Repository for Open Soil Data -- \emph{\strong{febr}}, \url{http://www.ufsm.br/febr}.
}
\examples{
library(magrittr)
observation(dataset = "ctb0003", variable = "taxon",
            progress = FALSE, verbose = FALSE) \%>\%
febr2spdf() \%>\%
sp::spplot(zcol = "taxon_sibcs_2009", auto.key = list(columns = 3), scales = list(draw = TRUE))
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
