% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{model.matrix.feis}
\alias{model.matrix.feis}
\title{model.matrix for feis objects}
\usage{
\method{model.matrix}{feis}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{feis}".}

\item{...}{further arguments.}
}
\value{
An object of class "\code{matrix}" for \code{model.matrix}.
}
\description{
Methods to extract transformed model matrix for "\code{feis}" objects.
}
\details{
\code{model.matrix} for \code{feis} objects returns the model or design matrix
of the respective FEIS model. This is the transformed (detrended) data,
which is used for estimation of the model in \code{lm()}.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry + as.factor(yeargr) | exp,
                 data = mwp, id = "id")
mf <- model.frame(feis.mod)
mm <- model.matrix(feis.mod)

}
\seealso{
\code{\link[feisr]{feis}}, \code{\link[stats]{model.matrix}}
}
