% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_interp_last}
\alias{get_interp_last}
\title{Extract the end point at each interpolation}
\usage{
get_interp_last(dt, group = NULL)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{group}{the variable to label different runs of the optimiser(s)}
}
\value{
a tibble object containing the last interpolating basis in each iteration
}
\description{
Extract the end point at each interpolation
}
\examples{
holes_1d_better \%>\% get_interp_last()
get_interp_last(dplyr::bind_rows(holes_1d_better, holes_1d_geo), group = method)
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp}()},
\code{\link{get_interrupt}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
