% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{[.ffdf}
\alias{[.ffdf}
\alias{[<-.ffdf}
\title{Reading and writing data.frames (ffdf)}
\usage{
\method{[}{ffdf} (x, i, j, drop = TRUE)

\method{[}{ffdf} (x, i, j) <- value
}
\arguments{
\item{x}{an \code{ff} object}

\item{i}{a row subscript}

\item{j}{a column subscript}

\item{drop}{logical. If TRUE the result is coerced to the lowest possible dimension.}

\item{value}{A suitable replacement value}
}
\value{
See \code{\link[ff]{Extract.ffdf}}. Mark that if a logical \code{ff} vector is used for \code{i}, and if only \code{FALSE} or \code{NA} 
values are present, this is not allowed as ffdf with zero rows do not exist.
}
\description{
Package \code{ff} does not allow to extract and set values of \code{ffdf} objects based on logical \code{ff} vectors. For this reason
the extractor functions \code{[.ffdf} and \code{[<-.ffdf} defined in package ff are overloaded.\cr
If you supply a logical \code{ff} vector as an index to subset an \code{ffdf} object, the overloaded function will convert the logical \code{ff} vector
to an integer \code{ff} index before using the \code{[.ffdf} and \code{[<-.ffdf} functions from the ff package. \cr
This allows to do \code{as.ffdf(iris)[as.ff(iris$Sepal.Length > 5), ]}\cr\cr
This is an extension to handle logical \code{ff} vectors as indexes to \code{ffdf} objects.
}
\examples{
## extractors for ffdf objects
data(iris)
x <- as.ffdf(iris)
x[x$Sepal.Length > 5, ]
x[x$Sepal.Length > 5, 1:3]
x[x$Sepal.Length > 5, 1, drop=TRUE]
x[x$Sepal.Length > 5, 1]
x[, 1]
x[, ]
x[c("Sepal.Length", "Sepal.Width")]
x[1:2]

## setters
data(iris)
x <- as.ffdf(iris)
testpositions <- x$Sepal.Length > 5
testpositions <- ffwhich(testpositions, testpositions == TRUE)
mynewdata <- x[testpositions, c("Sepal.Length", "Sepal.Width")]
mynewdata$Sepal.Length <- ff(1, length = nrow(mynewdata))
x[x$Sepal.Length > 5, c("Sepal.Length", "Sepal.Width")] <- mynewdata
x[testpositions, ]

data(iris)
x <- as.ffdf(iris)
testpositions <- x$Sepal.Length > 5
testpositions <- ffwhich(testpositions, testpositions == TRUE)
mynewdata <- x[testpositions, c("Sepal.Length", "Sepal.Width")]
mynewdata$Sepal.Length <- ff(1, length = nrow(mynewdata))
x[testpositions, c("Sepal.Length", "Sepal.Width")] <- mynewdata
x[testpositions, ]




}
\seealso{
\code{\link[ff]{Extract.ffdf}}
}
