% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/players.R
\name{list_players}
\alias{list_players}
\title{Find fantasy players}
\usage{
list_players(
  leagueId = ffl_id(),
  sort = "ROST",
  position = NULL,
  status = "AVAILABLE",
  injured = NULL,
  proTeam = NULL,
  scoreType = c("STANDARD", "PPR"),
  limit = 50
)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{sort}{The column from which to sort the data. Options match those on
the ESPN website:
\itemize{
\item "PLAYER" = Alphabetical by player name
\item "PROJ" = Projection is ESPN’s projected fantasy score for a player’s
upcoming game.
\item "SCORE" = Actual score for \code{scoringPeriodId}
\item "OPRK" = Opponent Rank shows how a player’s upcoming NFL opponent
performs against that player’s position. Low numbers mean it may be a
tough opponent; high numbers an easier opponent.
\item "START" = Start Percentage shows the number of fantasy leagues a player
is started in divided by the number of leagues he is eligible in. This
helps indicate how the public views a player.
\item "ROST" = Rostered Percentage shows the number of fantasy leagues in
which a player is on a roster divided by the total number of fantasy
leagues. This helps indicate how the public views a player.
\item "CHANGE" = Plus/Minus shows the change in \%ROST over the last week. This
will help show which players are hot and cold at a given moment.
\item "PRK" = Position Rank shows how a player stacks up against other players
at his position. No. 1 is best.
\item "FPTS" = Total fantasy points scored thus far in the season.
\item "AVG" = Average fantasy points scored in each game started.
\item "LAST" = Last shows the player’s fantasy score in his team’s last game.
}}

\item{position}{Abbreviation of player positions to filter, \code{NULL} for all:
\itemize{
\item "QB" = Quarterback
\item "RB" = Running Back
\item "WR" = Wide Receiver
\item "TE" = Tight End
\item "FLEX" = Running Backs, Wide Receivers and Tight Ends can be used in this
position
\item "D/ST" = Defense and Special Teams
\item "K" = Kicker
}}

\item{status}{Availability status of player, one or more from:
\itemize{
\item "ALL"
\item "AVAILABLE" (default)
\item "FREEAGENT"
\item "WAIVERS"
\item "ONTEAM"
}}

\item{injured}{Whether to return only injured or healthy players. Use \code{NULL}
(default) for all players, \code{TRUE} for injured players, and \code{FALSE} for
healthy players.}

\item{proTeam}{The abbreviation or ID of the professional team from which
players should be returned. See \code{pro_teams()} for a list of all possible
team abbreviations.}

\item{scoreType}{The type of scoring used: "STANDARD" or "PPR."}

\item{limit}{The limit of players to return. Use \code{""} or \code{NULL} to return
all. Defaults to 50, which is the default limit used by ESPN. Removing the
limit can make the request take a long time.}
}
\value{
A data frame of players.
}
\description{
Filter fantasy players by their position, availability, professional team,
and/or injury status. Sort and limit the responses in the same way as is
done in the ESPN Fantasy Football website.
}
\examples{
list_players("42654852", proTeam = "Mia", sort = "START", limit = 3)
}
\seealso{
Other player functions: 
\code{\link{all_players}()},
\code{\link{player_info}()},
\code{\link{player_news}()},
\code{\link{player_outlook}()},
\code{\link{recent_activity}()},
\code{\link{transaction_counter}()}
}
\concept{player functions}
