% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_information.R
\name{crisp}
\alias{crisp}
\alias{crisp.default}
\alias{crisp.numeric}
\alias{crisp.matrix}
\alias{crisp.ts}
\alias{crisp.xts}
\alias{crisp.data.frame}
\alias{crisp.tbl_df}
\title{Full Information by Market Conditioning}
\usage{
crisp(x, lgl)

\method{crisp}{default}(x, lgl)

\method{crisp}{numeric}(x, lgl)

\method{crisp}{matrix}(x, lgl)

\method{crisp}{ts}(x, lgl)

\method{crisp}{xts}(x, lgl)

\method{crisp}{data.frame}(x, lgl)

\method{crisp}{tbl_df}(x, lgl)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{lgl}{A \code{logical} vector with TRUE's and FALSE's indicating which scenarios should considered.}
}
\value{
A numerical vector of class \code{ffp} with the new
probabilities distribution.
}
\description{
Give full weight to occurrences that satisfies a logical condition.
}
\examples{
library(ggplot2)
# invariance (stationarity)
ret <- diff(log(EuStockMarkets))

# full weight on scenarios where CAC returns were above 2\%
market_condition <- crisp(x = ret, ret[ , 3] > 0.02)
market_condition

autoplot(market_condition) +
  scale_color_viridis_c()
}
\seealso{
\code{\link{exp_decay}} \code{\link{kernel_normal}}
}
