% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/originalRcodePrechange.R
\name{CUSUM_stream_jumpdetect_prechange}
\alias{CUSUM_stream_jumpdetect_prechange}
\title{CUSUM change detection for a stream in R with known prechange parameters}
\usage{
CUSUM_stream_jumpdetect_prechange(stream, BL, params, mu0, sigma0)
}
\arguments{
\item{stream}{The stream of observations.}

\item{BL}{The burn-in length - this won't actually be used, but is kept
for historical reasons.}

\item{params}{A list of parameters for the CUSUM algorithm. Consists of
             \describe{
                 \item{\code{d}}{A control parameter also known as 
                                 \eqn{k}.}

                 \item{\code{B}}{A control parameter also known as 
                                 \eqn{h}.}
             }}

\item{mu0}{The prechange mean, which is assumed known in this context}

\item{sigma0}{The prechange standard deviation, which is assumed known 
in this context}
}
\value{
A vector of estimated changepoints.
}
\description{
Original implementation in R of CUSUM change detector, but now
expecting the prechange mean and variance to be specified.
}
\section{Author}{

Dean Bodenham
}

\section{References}{

D. A. Bodenham and N. M. Adams (2016) 
\emph{Continuous monitoring for changepoints in data 
streams using adaptive estimation}. 
Statistics and Computing  
doi:10.1007/s11222-016-9684-8
}

\keyword{internal}
