% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{makeStreamMeanChangeR}
\alias{makeStreamMeanChangeR}
\title{Create a stream with a certain number of changes}
\usage{
makeStreamMeanChangeR(
  numChanges = 3,
  regimeLength = 150,
  seednum = NULL,
  mu0 = 0,
  sigma0 = 1
)
}
\arguments{
\item{regimeLength}{The number of observations between changepoints
(before and after). Default is \code{150}.}

\item{seednum}{The seed for the random number generator. Default is
\code{NULL}, in which case no seed will be used.}

\item{mu0}{The initial mean of the process.}

\item{sigma0}{The variance of each stream.}

\item{x}{numChanges The number of changepoints. Default is \code{3}.}
}
\value{
A vector of observations.
}
\description{
A function, used almost exclusively in testing, to generate a stream
of observations with a certain number of changepoints.
}
\details{
Creates a stream of observations, where after each changepoint
         the mean increases by one standard deviation.
}
\keyword{internal}
