% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_tag_status}
\alias{theme_tag_status}
\title{Theme for \code{plot_base_census()}.}
\usage{
theme_tag_status(
  panel.grid.major = element_line(colour = "black"),
  panel.grid.minor = element_line(colour = "black", linetype = "dotted"),
  panel.background = element_rect(fill = "white"),
  plot.title = element_text(size = 20),
  plot.subtitle = element_text(size = 12),
  plot.caption = element_text(size = 8),
  legend.position = "top",
  legend.title = element_blank(),
  axis.ticks = element_blank(),
  axis.text = element_text(size = 12),
  ...
)
}
\arguments{
\item{panel.grid.major}{grid lines (\code{\link[ggplot2:element]{element_line()}}). Specify major grid lines,
or minor grid lines separately (using \code{panel.grid.major} or \code{panel.grid.minor})
or individually for each axis (using \code{panel.grid.major.x}, \code{panel.grid.minor.x},
\code{panel.grid.major.y}, \code{panel.grid.minor.y}).  Y axis grid lines are horizontal
and x axis grid lines are vertical. \verb{panel.grid.*.*} inherits from
\verb{panel.grid.*} which inherits from \code{panel.grid}, which in turn inherits
from \code{line}}

\item{panel.grid.minor}{grid lines (\code{\link[ggplot2:element]{element_line()}}). Specify major grid lines,
or minor grid lines separately (using \code{panel.grid.major} or \code{panel.grid.minor})
or individually for each axis (using \code{panel.grid.major.x}, \code{panel.grid.minor.x},
\code{panel.grid.major.y}, \code{panel.grid.minor.y}).  Y axis grid lines are horizontal
and x axis grid lines are vertical. \verb{panel.grid.*.*} inherits from
\verb{panel.grid.*} which inherits from \code{panel.grid}, which in turn inherits
from \code{line}}

\item{panel.background}{background of plotting area, drawn underneath plot
(\code{\link[ggplot2:element]{element_rect()}}; inherits from \code{rect})}

\item{plot.title}{plot title (text appearance) (\code{\link[ggplot2:element]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{\link[ggplot2:element]{element_text()}};
inherits from \code{title}) left-aligned by default}

\item{plot.caption}{caption below the plot (text appearance)
(\code{\link[ggplot2:element]{element_text()}}; inherits from \code{title}) right-aligned by default}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{legend.title}{title of legend (\code{\link[ggplot2:element]{element_text()}}; inherits from
\code{title})}

\item{axis.ticks}{tick marks along axes (\code{\link[ggplot2:element]{element_line()}}). Specify all tick marks (\code{axis.ticks}),
ticks by plane (using \code{axis.ticks.x} or \code{axis.ticks.y}), or individually
for each axis (using \code{axis.ticks.x.bottom}, \code{axis.ticks.x.top},
\code{axis.ticks.y.left}, \code{axis.ticks.y.right}). \verb{axis.ticks.*.*} inherits from
\verb{axis.ticks.*} which inherits from \code{axis.ticks}, which in turn inherits
from \code{line}}

\item{axis.text}{tick labels along axes (\code{\link[ggplot2:element]{element_text()}}). Specify all axis tick labels (\code{axis.text}),
tick labels by plane (using \code{axis.text.x} or \code{axis.text.y}), or individually
for each axis (using \code{axis.text.x.bottom}, \code{axis.text.x.top},
\code{axis.text.y.left}, \code{axis.text.y.right}). \verb{axis.text.*.*} inherits from
\verb{axis.text.*} which inherits from \code{axis.text}, which in turn inherits
from \code{text}}

\item{...}{additional element specifications not part of base ggplot2. In general,
these should also be defined in the \verb{element tree} argument.}
}
\description{
Theme for \code{plot_base_census()}.
}
\examples{
class(theme_tag_status())
}
\seealso{
Other functions to plot tag status: 
\code{\link{header_tag_status}()},
\code{\link{plot_tag_status_by_subquadrat}()}
}
\concept{functions to plot tag status}
\keyword{internal}
