#
# fields  is a package for analysis of spatial data written for
# the R software environment.
# Copyright (C) 2024 Colorado School of Mines
# 1500 Illinois St., Golden, CO 80401
# Contact: Douglas Nychka,  douglasnychka@gmail.com,
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the R software environment if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# or see http://www.r-project.org/Licenses/GPL-2
##END HEADER
"rdist" <- function(x1, x2 = NULL, compact = FALSE) {
	if (!is.matrix(x1)) {
		x1 <- as.matrix(x1)
	}
  if (is.null(x2)) {
		storage.mode(x1) <- "double"
		if (compact)
			  return(dist(x1))
		else
			return(.Call("RdistC", x1, x1, PACKAGE = "fields"))
	} else {
	  if (!is.matrix(x2)) {
			x2 <- as.matrix(x2)
		}
		storage.mode(x1) <- "double"
		storage.mode(x2) <- "double"
		return(.Call("RdistC", x1, x2, PACKAGE = "fields"))
	}

}
