% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fire.R
\docType{class}
\name{Fire}
\alias{Fire}
\title{Generate a New App Object}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\description{
The Fire generator creates a new 'Fire'-object, which is the the class 
containing all app logic. The class is based on the R6 oo-system and is thus
reference-based with methods and data attached to each object, in contrast to
the more well known S3 and S4 systems.
}
\section{Fields}{

\describe{
 \item{\code{host}}{A string giving a valid IPv4 address owned by the server, or '0.0.0.0' (the default) to listen on all addresses}
 \item{\code{port}}{An integer giving the port number the server should listen on (defaults to 80L)}
 \item{\code{refreshRate}}{The interval in seconds between run cycles when running a blocking server (defaults to 0.001)}
 \item{\code{triggerDir}}{A valid folder where trigger files can be put when running a blocking server (defaults to NULL)}
}
}

\section{Methods}{

\describe{
 \item{\code{ignite(block = TRUE, showcase = FALSE, ...)}}{Begins the server,either blocking the console if \code{block = TRUE} or not. If \code{showcase = TRUE} a browser window is opened directing at the server address. \code{...} will be redirected to the 'start' handler(s)}
 \item{\code{start(block = TRUE, showcase = FALSE, ...)}}{A less dramatic synonym of for \code{ignite}}
 \item{\code{reignite(block = TRUE, showcase = FALSE, ...)}}{As \code{ignite} but additionally triggers the 'resume' event after the 'start' event}
 \item{\code{resume(block = TRUE, showcase = FALSE, ...)}}{Another less dramatic synonym, this time for reignite}
 \item{\code{extinguish()}}{Stops a running server}
 \item{\code{stop()}}{Boring synonym for \code{extinguish}}
 \item{\code{on(event, handler, pos = NULL)}}{Add a handler function to to an event at the given position in the handler stack. Returns a string uniquely identifying the handler}
 \item{\code{off(handlerId)}}{Remove the handler tied to the given id}
 \item{\code{trigger(event, ...)}}{Triggers an event passing the additional arguments to the potential handlers}
 \item{\code{send(message, id)}}{Sends a websocket message to the client with the given id, or to all connected clients if id is missing}
 \item{\code{attach(plugin, ...)}}{Attaches a plugin to the server. A plugin is an R6 object with an \code{onAttach} method}
 \item{\code{header(name, value)}}{Add a global header to the server that will be set on all responses}
 \item{\code{set_data(name, value)}}{Adds data to the servers internal data store}
 \item{\code{get_data(name)}}{Extracts data from the internal data store}
 \item{\code{remove_data(name)}}{Removes the data with the given name from the internal data store}
 \item{\code{time(expr, then, after, loop = FALSE)}}{Add a timed evaluation that will be evaluated after the given number of seconds, potentially repeating if loop=TRUE. After the expression has evaluated the 'then' function will get called with the result of the expression and the server object as arguments.}
 \item{\code{remove_time(id)}}{Removes the timed evaluation identified by the id (returned when adding the evaulation)}
 \item{\code{delay(expr, then)}}{As time except the expr is evaluated immediately at the end of the loop cycle}
 \item{\code{remove_delay(id)}}{Removes the delayed evaluation identified by the id}
 \item{\code{async(expr, then)}}{As delay and time except the expression is evaluated asynchronously. The progress of evaluation is checked at the end of each loop cycle}
 \item{\code{remove_async(id)}}{Removes the async evaluation identified by the id. The evaluation is not necessarily stopped but the then function will not get called.}
 \item{\code{set_client_id_converter(converter)}}{Sets the function that converts an HTTP request into a specific client id}
 \item{\code{test_request(request)}}{Test the result of recieving a specific HTTP request}
 \item{\code{test_header(request)}}{Test the result of recieving a specific HTTP header}
 \item{\code{test_message(request, binary, message, withClose = TRUE)}}{Test the result of recieving a message over websocket and potentially closing the connection afterwards}
 \item{\code{test_websocket(request, message)}}{Test the result of sending a message over websocket}
}
}

\examples{
# Create a New App
app <- Fire$new()
app$port <- 4689

# Setup the data everytime it starts
app$on('start', function(server, ...) {
    server$set_data('visits', 0)
    server$set_data('cycles', 0)
})

# Count the number of cycles
app$on('cycle-start', function(server, ...) {
    server$set_data('cycles', server$get_data('cycles') + 1)
})

# Count the number of requests
app$on('before-request', function(server, ...) {
    server$set_data('visits', server$get_data('visits') + 1)
})

# Handle requests
app$on('request', function(server, ...) {
    list(
        status = 200L,
        headers = list('Content-Type' = 'text/html'),
        body = paste('This is indeed a test. You are number', server$get_data('visits'))
    )
})

# Show number of requests in the console
app$on('after-request', function(server, ...) {
    message(server$get_data('visits'))
    flush.console()
})

# Terminate the server after 300 cycles
app$on('cycle-end', function(server, ...) {
    if (server$get_data('cycles') > 300) {
        message('Ending...')
        flush.console()
        server$extinguish()
    }
})

# Be polite
app$on('end', function(server) {
    message('Goodbye')
    flush.console()
})

\dontrun{
app$ignite(showcase = TRUE)
}

}
\keyword{datasets}
