% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism.plots.R
\name{plotSigBars}
\alias{plotSigBars}
\title{Add significance bars to a prism plot}
\usage{
plotSigBars(formula, data, type = c("tukey", "dunn"))
}
\arguments{
\item{formula}{a R formula object}

\item{data}{a dataset containing the variables in formula}

\item{type}{either "tukey" or "dunn" indicating which multiple comparison should be used}
}
\description{
Add significance bars to a prism plot, corrected for multiple comparisons either using Tukey's HSD (parametric),
or Dunn's correction for multiple comparison (non-parametric).
}
\note{
This function should probably only be used when the number of groups is less than four, otherwise the number
of pairwise comparisons becomes too large to display. 

When p-values are adjusted using Dunn's multiple comparison, this function calls the \code{kruskalmc} function in the
\code{pgirmess} package. To avoid having to load the entire package, the function was directly copied into the fifer package. 
references Patrick Giraudoux (2013). pgirmess: Data analysis in ecology. R package version 1.5.7. http://CRAN.R-project.org/package=pgirmess
}
\examples{
prism.plots(Sepal.Length ~ Species, data = iris, centerfunc=mean)
plotSigBars(Sepal.Length ~ Species, data = iris, type="tukey")
}
\author{
Dustin Fife
}
\seealso{
\code{\link{boxplot}}, \code{\link{densityPlotR}}, \code{\link{prism.plots}}
}

