% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unfactor.R
\name{unfactor}
\alias{unfactor}
\title{Convert a factor to a character (or number)}
\usage{
unfactor(x, levels, labels, numeric = FALSE)
}
\arguments{
\item{x}{The vector of factors you wish to replace}

\item{levels}{A numeric vector of the values that will replace the factors}

\item{labels}{A character vector of the values to be replaced}

\item{numeric}{Should the labels be returned (i.e., characters)? Or the numbers?}
}
\value{
A numeric or character vector
}
\description{
Analogous to the function \code{\link{factor}}, \code{unfactor}	will convert a factor to a character or integer
}
\examples{
	#### create sample of male/female participants (at random)
x = as.factor(sample(c("Male", "Female"), 12, replace=TRUE))
unfactor(x, levels=c(0,1), labels=c("Male", "Female"))
}
\author{
Dustin Fife
}
\seealso{
\code{\link{factor}}
}

