% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{gcurve}
\alias{gcurve}
\title{gcurve}
\usage{
gcurve(
  expr,
  from = NULL,
  to = NULL,
  n = 101,
  add = FALSE,
  type = "l",
  xname = "x",
  xlab = xname,
  ylab = NULL,
  log = NULL,
  xlim = NULL,
  category = NULL,
  ...
)
}
\arguments{
\item{expr}{inherited from curve}

\item{from}{inherited from curve}

\item{to}{the range over which the function will be plotted.}

\item{n}{inherited from curve}

\item{add}{inherited from curve}

\item{type}{inherited from curve}

\item{xname}{inherited from curve}

\item{xlab}{inherited from curve}

\item{ylab}{inherited from curve}

\item{log}{inherited from curve}

\item{xlim}{inherited from curve}

\item{category}{option to add a column populated with a factor (by gcurve)}

\item{...}{inherited from curve}
}
\value{
A data.frame is returned. Columns include x, y, and optionally category.
}
\description{
A function to exploit base R's curve function.  This returns a data.frame holding x and y values returned from a call to curve, but suppress the plotting of that function
}
\examples{
{
require(ggplot2)
curve(dnorm(x, mean=0, sd=1), from=-4, to = 4, n= 1001)
ggplot(gcurve(expr = dnorm(x, mean=0, sd=1),from=-4, to = 4, n= 1001,
category= "Standard Normal"), aes(x=x, y=y)) + geom_line()
}
}
\seealso{
graphics::curve
}
\author{
Greg Cicconetti
}
