% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qiime1meco.R
\name{qiime1meco}
\alias{qiime1meco}
\title{Transform 'QIIME' results to 'microtable' object.}
\usage{
qiime1meco(
  otu_table,
  sample_data = NULL,
  phylo_tree = NULL,
  rep_fasta = NULL,
  ...
)
}
\arguments{
\item{otu_table}{the otu table generated from 'QIIME'. Taxonomic information should be in the end of the file.}

\item{sample_data}{default NULL; If provided, must be tab or comma seperated file, generally, a file with suffix "tsv" or "csv".}

\item{phylo_tree}{default NULL; the phylogenetic tree; generally, a file with suffix "tre".}

\item{rep_fasta}{default NULL; the representative sequences; a fasta file, generally with suffix "fasta" or "fna" or "fa".}

\item{...}{parameter passed to microtable$new function of microeco package, such as auto_tidy parameter.}
}
\value{
microtable object.
}
\description{
Transform 'QIIME' results to microtable object.
}
\examples{
\dontrun{
# use the raw data files stored inside the package
otu_file_path <- system.file("extdata", "otu_table_raw.txt", package="file2meco")
sample_file_path <- system.file("extdata", "sample_info.csv", package="file2meco")
phylo_file_path <- system.file("extdata", "rep_phylo.tre", package="file2meco")
rep_fasta_path <- system.file("extdata", "rep.fna", package="file2meco")
qiime1meco(otu_table = otu_file_path, sample_data = sample_file_path)
qiime1meco(otu_table = otu_file_path, sample_data = sample_file_path, 
  phylo_tree = phylo_file_path)
qiime1meco(otu_table = otu_file_path, sample_data = sample_file_path, 
  phylo_tree = phylo_file_path, rep_fasta = rep_fasta_path)
}
}
