% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qiime2meco.R
\name{qiime2meco}
\alias{qiime2meco}
\title{Transform 'QIIME2' results to 'microtable' object.}
\usage{
qiime2meco(
  feature_table,
  sample_table = NULL,
  match_table = NULL,
  taxonomy_table = NULL,
  phylo_tree = NULL,
  rep_fasta = NULL,
  ...
)
}
\arguments{
\item{feature_table}{the ASV abundance data with qza format, such as the \code{'data2_table.qza'} in the example.}

\item{sample_table}{default NULL; the sample metadata table; four types of formats are available: \cr
1) q2-type tab seperated file of QIIME2, such as the \code{'sample-metadata.tsv'} in the example;\cr
2) comma seperated file with the suffix csv or tab seperated file with suffix tsv or txt;\cr
3) Excel type file with the suffix xlsx or xls; require \code{readxl} package to be installed;\cr
4) \code{data.frame} object from R.}

\item{match_table}{default NULL; a two column table used to replace the sample names in feature table; Must be two columns without column names;
The first column must be raw sample names same with those in feature table, 
the second column must be new sample names same with the rownames in sample_table; Please also see the example files.
If provided, must be one of the several types of formats: \cr
1) comma seperated file with the suffix csv or tab seperated file with suffix tsv or txt; \cr
2) Excel type file with the suffix xlsx or xls; require \code{readxl} package to be installed; \cr
3) \code{data.frame} object from R.}

\item{taxonomy_table}{default NULL; the taxonomy assignment data with qza format, such as the \code{'taxonomy.qza'} in the example.}

\item{phylo_tree}{default NULL; the phylogenetic tree with qza format, such as the \code{'tree.qza'} in the example.}

\item{rep_fasta}{default NULL; the representative sequences with qza format, such as the \code{'dada2_rep_set.qza'} in the example.}

\item{...}{parameter passed to \code{microtable$new} function of \code{microeco} package, such as \code{auto_tidy} parameter.}
}
\value{
\code{microtable} object.
}
\description{
Transform 'QIIME2' qza results to microtable object.
}
\examples{
\dontrun{
# The data files is downloaded from https://docs.qiime2.org/2020.8/tutorials/pd-mice/ 
#   and stored inside the package.
abund_file_path <- system.file("extdata", "dada2_table.qza", package="file2meco")
sample_file_path <- system.file("extdata", "sample-metadata.tsv", package="file2meco")
taxonomy_file_path <- system.file("extdata", "taxonomy.qza", package="file2meco")
qiime2meco(abund_file_path)
qiime2meco(abund_file_path, sample_table = sample_file_path)
qiime2meco(abund_file_path, sample_table = sample_file_path, 
  taxonomy_table = taxonomy_file_path)
}
}
