# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

PasteCollapse <- function(strings, collapse) {
    .Call('filesstrings_PasteCollapse', PACKAGE = 'filesstrings', strings, collapse)
}

#' Apply paste collapse to each element of a list.
#'
#' This is the same as doing
#' \code{sapply(char.list, paste, collapse = collapse)}, it's just faster.
#'
#' @param char_list A list of character vectors.
#' @param collapse See \code{\link{paste}}.
#'
#' @return A list of character vectors.
#'
#' @examples
#' PasteCollapseListElems(list(1:3, c("a", 5, "rory")), collapse = "R")
#' @export
PasteCollapseListElems <- function(char_list, collapse = "") {
    .Call('filesstrings_PasteCollapseListElems', PACKAGE = 'filesstrings', char_list, collapse)
}

#' Remove empty strings from a character list.
#'
#' @param char_list A list of character vectors.
#'
#' @return A list of character vectors.
#'
#' @examples
#' StrListRemoveEmpties(list(c("a", "", "b"), "gg", c("", 1, "")))
#' @export
StrListRemoveEmpties <- function(char_list) {
    .Call('filesstrings_StrListRemoveEmpties', PACKAGE = 'filesstrings', char_list)
}

#' Get the nth element of each vector in a list of numeric or character
#' vectors.
#'
#' These are faster implementations of procedures that could very easily be
#' done with [base::sapply].
#'
#' @param char_list A list of character vectors.
#' @param n The index of the element that you want from each vector.
#'
#' @return A list.
#'
#' @examples
#' CharListElemsNthElem(list(c("a", "b", "c"), c("d", "f", "a")), 2)
#' NumListElemsNthElem(list(1:5, 0:2), 4)
#' @export
CharListElemsNthElem <- function(char_list, n) {
    .Call('filesstrings_CharListElemsNthElem', PACKAGE = 'filesstrings', char_list, n)
}

#' @rdname CharListElemsNthElem
#' @param num_list A list of numeric vectors.
#' @export
NumListElemsNthElem <- function(num_list, n) {
    .Call('filesstrings_NumListElemsNthElem', PACKAGE = 'filesstrings', num_list, n)
}

InterleaveStrings <- function(strings1, strings2) {
    .Call('filesstrings_InterleaveStrings', PACKAGE = 'filesstrings', strings1, strings2)
}

IsPrefix <- function(whole, pre) {
    .Call('filesstrings_IsPrefix', PACKAGE = 'filesstrings', whole, pre)
}

CorrectInterleave0 <- function(orig, strings1, strings2) {
    .Call('filesstrings_CorrectInterleave0', PACKAGE = 'filesstrings', orig, strings1, strings2)
}

CorrectInterleave <- function(orig, strings1, strings2) {
    .Call('filesstrings_CorrectInterleave', PACKAGE = 'filesstrings', orig, strings1, strings2)
}

InterleaveStringList <- function(strings1, strings2) {
    .Call('filesstrings_InterleaveStringList', PACKAGE = 'filesstrings', strings1, strings2)
}

