% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{move_files}
\alias{move_files}
\alias{file.move}
\title{Move files around.}
\usage{
move_files(files, destinations)

file.move(files, destinations)
}
\arguments{
\item{files}{A character vector of files to move (relative or absolute
paths).}

\item{destinations}{A character vector of the destination directories into
which to move the files.}
}
\value{
Invisibly, a logical vector with a \code{TRUE} for each time the operation
succeeded and a \code{FALSE} for every fail.
}
\description{
Move specified files into specified directories
}
\details{
If there are \eqn{n} files, there must be either \eqn{1} or \eqn{n}
directories. If there is one directory, then all \eqn{n} files are moved
there. If there are \eqn{n} directories, then each file is put into its
respective directory. This function also works to move directories.

If you try to move files to a directory that doesn't exist, the directory is
first created and then the files are put inside.
}
\examples{
\dontrun{
dir.create("dir")
files <- c("1litres_1.txt", "1litres_30.txt", "3litres_5.txt")
file.create(files)
file.move(files, "dir")}
}
