% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-after.R, R/str-before.R
\name{str_after_nth}
\alias{str_after_nth}
\alias{str_after_first}
\alias{str_after_last}
\alias{str_before_nth}
\alias{str_before_first}
\alias{str_before_last}
\title{Text before or after \eqn{n}th occurrence of pattern.}
\usage{
str_after_nth(strings, pattern, n)

str_after_first(strings, pattern)

str_after_last(strings, pattern)

str_before_nth(strings, pattern, n)

str_before_first(strings, pattern)

str_before_last(strings, pattern)
}
\arguments{
\item{strings}{A character vector.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}

\item{n}{A natural number to identify the \eqn{n}th occurrence (defaults to
first (\code{n = 1})). This can be negatively indexed, so if you wish to select
the \emph{last} occurrence, you need \code{n = -1}, for the second-last, you
need \code{n = -2} and so on.}
}
\value{
A character vector of the desired strings.
}
\description{
Extract the part of a string which is before or after the \emph{n}th occurrence of
a specified pattern, vectorized over the string. \code{n} can be negatively
indexed. See 'Arguments'.
}
\details{
\itemize{ \item \code{str_after_first(...)} is just \code{str_after_nth(..., n = 1)}.
\item \code{str_after_last(...)} is just \code{str_after_nth(..., n = -1)}. \item
\code{str_before_first(...)} is just \code{str_before_nth(..., n = 1)}. \item
\code{str_before_last(...)} is just \code{str_before_nth(..., n = -1)}. }
}
\examples{
string <- "ab..cd..de..fg..h"
str_after_nth(string, "\\\\.\\\\.", 3)
str_before_nth(string, "e", 1)
str_before_nth(string, "\\\\.", -3)
str_before_nth(string, ".", -3)
str_before_nth(rep(string, 2), fixed("."), -3)
}
