% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryfactorlist.R
\name{summary_factorlist}
\alias{summary_factorlist}
\title{Summarise a set of factors (or continuous variables) by a dependent variable}
\usage{
summary_factorlist(.data, dependent = NULL, explanatory, cont = "mean",
  p = FALSE, na_include = FALSE, column = FALSE, total_col = FALSE,
  orderbytotal = FALSE, fit_id = FALSE, na_to_missing = TRUE,
  add_dependent_label = FALSE, dependent_label_prefix = "Dependent: ",
  dependent_label_suffix = "")
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1:  name of dependent variable
(2 to 5 factor levels).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{cont}{Summary for continuous variables: "mean" (standard deviation) or
"median" (interquartile range).}

\item{p}{Logical: Include statistical test (see
\code{\link[Hmisc]{summary.formula}}).}

\item{na_include}{Logical: include missing data in summary (\code{NA}).}

\item{column}{Logical: Compute margins by column rather than row.}

\item{total_col}{Logical: include a total column summing across factor
levels.}

\item{orderbytotal}{Logical: order final table by total column high to low.}

\item{fit_id}{Logical: not used directly, allows merging via
\code{\link{finalfit_merge}}.}

\item{na_to_missing}{Logical: convert \code{NA} to 'Missing' when
\code{na_include=TRUE}.}

\item{add_dependent_label}{Add the name of the dependent label to the top
left of table}

\item{dependent_label_prefix}{Add text before dependent label}

\item{dependent_label_suffix}{Add text after dependent label}
}
\value{
Returns a \code{factorlist} dataframe.
}
\description{
A function that takes a single dependent variable with a vector of
explanatory variable names (continuous or categorical variables) to produce a
summary table.
}
\details{
This function is mostly a wrapper for \code{Hmisc:::summary.formula(...,
method = "reverse")} but produces a publication-ready table the way we like
them. It usually takes a categorical dependent variable (with two to five
levels) to produce a cross table of counts and proportions expressed as
percentages. However, it will take a continuous dependent variable to produce
mean (standard deviation) or median (interquartile range) for use with linear
regression models.
}
\examples{
library(finalfit)
library(dplyr)
# Load example dataset, modified version of survival::colon
data(colon_s)

# Table 1 - Patient demographics ----
explanatory = c("age", "age.factor", "sex.factor", "obstruct.factor")
dependent = "perfor.factor"
colon_s \%>\%
	summary_factorlist(dependent, explanatory, p=TRUE)

# summary.factorlist() is also commonly used to summarise any number of
# variables by an outcome variable (say dead yes/no).

# Table 2 - 5 yr mortality ----
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"
colon_s \%>\%
	summary_factorlist(dependent, explanatory)
}
\seealso{
\code{\link{fit2df}}
}
