% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_occurrence.R
\name{finbif_occurrence}
\alias{finbif_occurrence}
\title{Download FinBIF occurrence records}
\usage{
finbif_occurrence(..., filter, select, order_by, n = 10, page = 1,
  count_only = FALSE, quiet = FALSE, cache = TRUE,
  check_taxa = TRUE, on_check_fail = c("warn", "error", "quiet"),
  date_time = TRUE, date_time_method = "fast",
  tzone = Sys.timezone(), dwc = FALSE)
}
\arguments{
\item{...}{Character vectors or list of character vectors. Taxa of records
to download.}

\item{filter}{List of named character vectors. Filters to apply to records.}

\item{select}{Character vector. Variables to return. If not specified a
default set of commonly used variables will be used. Use \code{"default_vars"}
as a shortcut for this set.}

\item{order_by}{Character vector. Variables to order records by before they
are returned. Most, though not all, variables can be used to order records
before they are returned. Ordering is ascending by default. To return in
descending order append a \code{-} to the front of the variable (e.g.,
\code{"-date_start"}). Default order is \code{"-date_start"} > \code{"-load_data"} >
\code{"reported_name"}.}

\item{n}{Integer. How many records to download.}

\item{page}{Integer. Which page of records to start downloading from.}

\item{count_only}{Logical. Only return the number of records available.}

\item{quiet}{Logical. Suppress the progress indicator for multipage
downloads.}

\item{cache}{Logical. Use cached data.}

\item{check_taxa}{Logical. Check first that taxa are in the FinBIF database.
If true only records that match known taxa (have a valid taxon ID) are
returned.}

\item{on_check_fail}{Character. What to do if a taxon is found not valid. One
of \code{"warn"} (default), \code{"error"} or \code{"continue"}.}

\item{date_time}{Logical. Convert raw date and time variables into date-time
and duration.}

\item{date_time_method}{Character. Passed to \code{lutz::tz_lookup_coords()} when
\code{date_time = TRUE}. Default is \code{"fast"}. Use
\code{date_time_method = "accurate"} (requires package \code{sf}) for greater
accuracy.}

\item{tzone}{Character. If \code{date_time = TRUE} the timezone of outputted
date-time. Defaults to system timezone.}

\item{dwc}{Logical. Return Darwin Core (or Darwin Core style) variable names.}
}
\value{
A \code{data.frame}. If \code{count_only =  TRUE} an integer.
}
\description{
Download filtered occurrence data from FinBIF as a \code{data.frame}.
}
\examples{
\dontrun{

# Get recent occurrence data for taxon
finbif_occurrence("Cygnus cygnus")

# Specify the number of records
finbif_occurrence("Cygnus cygnus", n = 100)

# Get multiple taxa
finbif_occurrence("Cygnus cygnus", "Ursus arctos")

# Filter the records
finbif_occurrence(
  species = "Cygnus cygnus",
  filter = list(coordinate_accuracy_max = 100)
)

}
}
