% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_records.R
\name{finbif_records}
\alias{finbif_records}
\title{Get FinBIF records}
\usage{
finbif_records(
  filter,
  select,
  order_by,
  sample = FALSE,
  n = 10,
  page = 1,
  count_only = FALSE,
  quiet = FALSE,
  cache = getOption("finbif_use_cache")
)
}
\arguments{
\item{filter}{List of named character vectors. Filters to apply to records.}

\item{select}{Character vector. Variables to return. If not specified a
default set of commonly used variables will be used. Use \code{"default_vars"}
as a shortcut for this set.}

\item{order_by}{Character vector. Variables to order records by before they
are returned. Most, though not all, variables can be used to order records
before they are returned. Ordering is ascending by default. To return in
descending order append a \code{-} to the front of the variable (e.g.,
\code{"-date_start"}). Default order is \code{"-date_start"} > \code{"-load_data"} >
\code{"reported_name"}.}

\item{sample}{Logical. If \code{TRUE} randomly sample the records from the FinBIF
database.}

\item{n}{Integer. How many records to download.}

\item{page}{Integer. Which page of records to start downloading from.}

\item{count_only}{Logical. Only return the number of records available.}

\item{quiet}{Logical. Suppress the progress indicator for multipage
downloads.}

\item{cache}{Logical. Use cached data.}
}
\value{
A \code{finbif_api} or \code{finbif_api_list} object.
}
\description{
Download records from FinBIF.
}
\examples{
\dontrun{

# Get the last 100 records from FinBIF
finbif_records(n = 100)
}
}
