library(testthat)
library(fingertipsR)

context("Deprivation extract")

# create progress bar so travis gets responses
pb <- txtProgressBar(style = 3)
setTxtProgressBar(pb, 0)

skip_if_offline()
dep_102_2015 <- deprivation_decile(AreaTypeID = 102, Year = 2015)
skip_if_offline()
dep_202_2015 <- deprivation_decile(AreaTypeID = 202, Year = 2015)
skip_if_offline()
dep_201_2015 <- deprivation_decile(AreaTypeID = 201, Year = 2015)
skip_if_offline()
dep_165_2015 <- deprivation_decile(AreaTypeID = 165, Year = 2015)
skip_if_offline()
dep_154_2015 <- deprivation_decile(AreaTypeID = 154, Year = 2015)
skip_if_offline()
dep_101_2015 <- deprivation_decile(AreaTypeID = 101, Year = 2015)
setTxtProgressBar(pb, 0.25)

skip_if_offline()
dep_8_2015 <- deprivation_decile(AreaTypeID = 8, Year = 2015)
skip_if_offline()
dep_7_2015 <- deprivation_decile(AreaTypeID = 7, Year = 2015)
skip_if_offline()
dep_3_2015 <- deprivation_decile(AreaTypeID = 3, Year = 2015)
skip_if_offline()
dep_202_2019 <- deprivation_decile(AreaTypeID = 202, Year = 2019)
skip_if_offline()
dep_201_2019 <- deprivation_decile(AreaTypeID = 201, Year = 2019)
skip_if_offline()
setTxtProgressBar(pb, 0.5)

dep_165_2019 <- deprivation_decile(AreaTypeID = 165, Year = 2019)
skip_if_offline()
dep_154_2019 <- deprivation_decile(AreaTypeID = 154, Year = 2019)
skip_if_offline()
dep_120_2019 <- deprivation_decile(AreaTypeID = 120, Year = 2019)
skip_if_offline()
dep_104_2019 <- deprivation_decile(AreaTypeID = 104, Year = 2019)
skip_if_offline()
dep_102_2019 <- deprivation_decile(AreaTypeID = 102, Year = 2019)
setTxtProgressBar(pb, 0.75)

skip_if_offline()
dep_101_2019 <- deprivation_decile(AreaTypeID = 101, Year = 2019)
skip_if_offline()
dep_46_2019 <- deprivation_decile(AreaTypeID = 46, Year = 2019)
skip_if_offline()
dep_7_2019 <- deprivation_decile(AreaTypeID = 7, Year = 2019)
skip_if_offline()
dep_6_2019 <- deprivation_decile(AreaTypeID = 6, Year = 2019)
setTxtProgressBar(pb, 1)

dep_cols <- 3
test_that("the columns of deprivation decile function are as expected", {
        skip_if_offline()
        expect_equal(ncol(dep_102_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_101_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_3_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_7_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_201_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_202_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_154_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_165_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_8_2015), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_202_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_201_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_165_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_154_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_120_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_104_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_102_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_101_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_46_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_7_2019), dep_cols)
        skip_if_offline()
        expect_equal(ncol(dep_6_2019), dep_cols)

})

test_that("the columns of deprivation decile function are as expected", {
        skip_if_offline()
        expect_true(nrow(dep_102_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_101_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_3_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_7_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_201_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_202_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_154_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_165_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_8_2015) > 2)
        skip_if_offline()
        expect_true(nrow(dep_202_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_201_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_165_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_154_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_120_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_104_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_102_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_101_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_46_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_7_2019) > 2)
        skip_if_offline()
        expect_true(nrow(dep_6_2019) > 2)

})

exp_classes <- c("character","numeric","integer")
names(exp_classes) <- c("AreaCode", "IMDscore", "decile")
test_that("the class of columns returned are character-numeric-integer", {
        skip_if_offline()
        expect_equal(vapply(dep_102_2015, class, character(1)), exp_classes)
        skip_if_offline()
        expect_equal(vapply(dep_101_2015, class, character(1)), exp_classes)
        skip_if_offline()
        expect_equal(vapply(dep_7_2015, class, character(1)), exp_classes)
        skip_if_offline()
        expect_equal(vapply(dep_3_2015, class, character(1)), exp_classes)
        skip_if_offline()
        expect_equal(vapply(dep_202_2019, class, character(1)), exp_classes)
})

test_that("error messages work correctly", {
        skip_if_offline()
        expect_error(deprivation_decile(Year = 2014, AreaTypeID = 102), "Year must be 2015 or 2019")
        skip_if_offline()
        expect_error(deprivation_decile(AreaTypeID = 12, Year = 2019),
                     "AreaTypeID must be one of 202, 201, 165, 154, 120, 104, 102, 101, 46, 8, 7, 6, 3")
        skip_if_offline()
        expect_error(deprivation_decile(AreaTypeID = 3, Year = 2019),
                     "AreaTypeID unavailable for 2019")
        skip_if_offline()
        expect_error(deprivation_decile(AreaTypeID = 120, Year = 2015),
                     "AreaTypeID unavailable for 2015")
        skip_if_offline()
        expect_error(deprivation_decile(Year = 2015),
                     "AreaTypeID must be specified")
})
