% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_concept_network.R
\name{fst_cn_plot}
\alias{fst_cn_plot}
\title{Plot Concept Network}
\usage{
fst_cn_plot(edges, nodes, concepts, title = NULL)
}
\arguments{
\item{edges}{Output of `fst_cn_edges()`, dataframe of 'edges' connecting two
words.}

\item{nodes}{Output of `fst_cn_nodes()`, dataframe of relevant lemmas and
their associated pagerank.}

\item{concepts}{List of terms which have been searched for, separated by
commas.}

\item{title}{Optional title for plot, default is `NULL` and a generic title
("Textrank extracted keyword occurrences") will be used.}
}
\value{
Plot of Concept Network.
}
\description{
Creates a Concept Network plot from a list of edges and nodes (and their
respective weights).
}
\examples{
con <- "kiusata, lyöminen"
cb <- conllu_cb_bullying_iso
edges <- fst_cn_edges(cb, con, pos_filter = c("NOUN", "VERB", "ADJ", "ADV"))
nodes <- fst_cn_nodes(cb, edges, c("NOUN", "VERB", "ADJ", "ADV"))
fst_cn_plot(edges = edges, nodes = nodes, concepts = con)
}
