% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_comparison_concept_network.R
\name{fst_cn_get_unique}
\alias{fst_cn_get_unique}
\title{Concept Network- Get unique nodes from a list of top n-grams tables}
\usage{
fst_cn_get_unique(list)
}
\arguments{
\item{list}{A list of top nodes}
}
\value{
Dataframe of words and whether word is unique or not.
}
\description{
Takes at least two tables of nodes and pagerank (output of `fst_cn_nodes()`)
and finds nodes unique to one table.
}
\examples{
pos_filter <- 'NOUN, VERB, ADJ, ADV'
e1 <- fst_cn_edges(fst_child, "lyödä", pos_filter = pos_filter)
e2 <- fst_cn_edges(fst_child, "lyöminen", pos_filter = pos_filter)
n1 <- fst_cn_nodes(fst_child, e1)
n2 <- fst_cn_nodes(fst_child, e2)
list_of_nodes <- list()
list_of_nodes <- append(list_of_nodes, list(n1))
list_of_nodes <- append(list_of_nodes, list(n2))
fst_cn_get_unique(list_of_nodes)
}
