% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_info.R
\name{get_run_info}
\alias{get_run_info}
\title{Get run info}
\usage{
get_run_info(
  experiment_name = NULL,
  run_name = NULL,
  storage_object = NULL,
  path = NULL
)
}
\arguments{
\item{experiment_name}{Name used to group similar runs under a
single experiment name.}

\item{run_name}{Name to distinguish one run of Finn from another.
The current time in UTC is appended to the run name to ensure
a unique run name is created.}

\item{storage_object}{Used to store outputs during a run to other
storage services in Azure. Could be a storage container object from
the 'AzureStor' package to connect to ADLS blob storage or a
OneDrive/SharePoint object from the 'Microsoft365R' package to connect
to a OneDrive folder or SharePoint site. Default of NULL will save outputs
to the local file system.}

\item{path}{String showing what file path the outputs should be written to.
Default of NULL will write the outputs to a temporary directory within R,
which will delete itself after the R session closes.}
}
\value{
Data frame of run log information
}
\description{
Lets you get all of the logging associated with a specific experiment or run.
}
\examples{
\donttest{
run_info <- set_run_info(
  experiment_name = "finn_forecast",
  run_name = "test_run"
)

run_info_tbl <- get_run_info(
  experiment_name = "finn_forecast"
)
}
}
