% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_data.R
\name{get_prepped_data}
\alias{get_prepped_data}
\title{Get Prepped Data}
\usage{
get_prepped_data(run_info, recipe, return_type = "df")
}
\arguments{
\item{run_info}{run info using the \code{\link[=set_run_info]{set_run_info()}} function}

\item{recipe}{recipe to return. Either a value of "R1" or "R2"}

\item{return_type}{return type}
}
\value{
table of prepped data
}
\description{
Get Prepped Data
}
\examples{
\donttest{
data_tbl <- timetk::m4_monthly \%>\%
  dplyr::rename(Date = date) \%>\%
  dplyr::mutate(id = as.character(id)) \%>\%
  dplyr::filter(
    id == "M2",
    Date >= "2012-01-01",
    Date <= "2015-06-01"
  )

run_info <- set_run_info()

prep_data(run_info,
  input_data = data_tbl,
  combo_variables = c("id"),
  target_variable = "value",
  date_type = "month",
  forecast_horizon = 3,
  recipes_to_run = "R1"
)

R1_prepped_data_tbl <- get_prepped_data(run_info,
  recipe = "R1"
)
}
}
