% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_ratio.R
\name{aspect_ratio}
\alias{aspect_ratio}
\title{A function to find aspect ratio}
\usage{
aspect_ratio(sp)
}
\arguments{
\item{sp}{A character value containing the species name}
}
\value{
dataframe with species, aspect ratio and taxonomy level.
}
\description{
A function to find aspect ratio of a species on either species or genus
level using rfishbase. It returns a data frame containing the aspect ratio
and the level at which the aspect ratio was found (species or genus).
}
\examples{
\dontrun{
library(fishflux)
library(plyr)
aspect_ratio("Lutjanus griseus")
plyr::ldply(lapply(c("Chlorurus spilurus","Zebrasoma scopas"), aspect_ratio))
}

}
\keyword{aspect-ratio}
\keyword{fish}
\keyword{fishbase}
