% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fish_shapes.R
\name{add_fishape}
\alias{add_fishape}
\title{fish silhouette in ggplot2}
\usage{
add_fishape(
  family = "Pomacanthidae",
  option = "Centropyge_loricula",
  xmin = -Inf,
  xmax = Inf,
  ymin = -Inf,
  ymax = Inf,
  scaled = FALSE,
  xlim = NULL,
  ylim = NULL,
  fill = "#000000",
  alpha = 1
)
}
\arguments{
\item{family}{character string indicating the fish family.}

\item{option}{character string indicating the fish species.
If NA, the first available option within a family will be selected}

\item{xmin}{x location giving minimum horizontal location of silhouette}

\item{xmax}{x location giving maximum horizontal location of silhouette}

\item{ymin}{y location giving minimum vertical location of silhouette}

\item{ymax}{y location giving maximum vertical location of silhouette}

\item{scaled}{logical parameter. If TRUE, location parameters
(xmin, xmax, ymin, ymax) should range between 0 and 1.
If FALSE, location parameters should be provided according to the values on
the plot axes.}

\item{xlim, ylim}{vectors of length = 2, contains the data limits
and must be provided if scaled is TRUE.}

\item{fill}{color of fish shape}

\item{alpha}{transparency of fish shape (value between 0 and 1)}
}
\description{
Adds a fish silhouette to your plot
}
\examples{
library(ggplot2)

ggplot() + add_fishape(fill = fish(n = 5)[4])

ggplot(diamonds)+
  geom_bar(aes(cut, fill = cut)) +
  scale_fill_fish_d(option = "Naso_lituratus") +
  add_fishape(family = "Acanthuridae",
              option = "Naso_unicornis",
              xmin = 1, xmax = 3, ymin = 15000, ymax = 20000,
              fill = fish(option = "Naso_lituratus", n = 5)[3],
              alpha = 0.8) +
  theme_bw()

## example with relative coordinates
ggplot(diamonds)+
  geom_bar(aes(cut, fill = cut)) +
  scale_fill_fish_d(option = "Naso_lituratus") +
  add_fishape(family = "Acanthuridae",
              option = "Naso_unicornis",
              xmin = 0, xmax = 0.3, ymin = 0.8, ymax = 1,
              scaled = TRUE,
              xlim = c(0.5, 5.5), ylim = c(0, 21000) ,
              fill = fish(option = "Naso_lituratus", n = 5)[3],
              alpha = 1) +
  theme_bw()

}
