% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMultiBin.R
\name{fitLMBin}
\alias{fitLMBin}
\title{Fitting the Lovinson Multiplicative Binomial Distribution when binomial
random variable, frequency, probability of success and theta parameter are given}
\usage{
fitLMBin(x,obs.freq,p,phi)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{p}{single value for probability of success.}

\item{phi}{single value for phi parameter.}
}
\value{
The output of \code{fitLMBin} gives the class format \code{fitLMB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitLMB} fitted probability values of \code{dLMBin}.

\code{NegLL} Negative Log Likelihood value.

\code{p} estimated probability value.

\code{phi} estimated phi parameter value.

\code{AIC} AIC value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted}
can be used to extract specific outputs.
}
\description{
The function will fit the Lovinson Multiplicative Binomial distribution
when random variables, corresponding frequencies, probability of success and phi parameter
are given. It will provide the expected frequencies, chi-squared test statistics value,
p value and degree of freedom  value so that it can be seen if this distribution
fits the data.
}
\details{
\deqn{obs.freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{0 < p < 1}
\deqn{0 < phi }
}
\examples{
No.D.D <- 0:7       #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)     #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLELMBin(x=No.D.D,freq=Obs.fre.1,p=0.1,phi=.3)

pLMBin=bbmle::coef(parameters)[1]    #assigning the estimated probability value
phiLMBin <- bbmle::coef(parameters)[2]  #assigning the estimated phi value

#fitting when the random variable,frequencies,probability and phi are given
results <- fitLMBin(No.D.D,Obs.fre.1,pLMBin,phiLMBin)
results

#extracting the AIC value
AIC(results)

#extract fitted values
fitted(results)

}
\references{
Elamir, E.A., 2013. Multiplicative-Binomial Distribution: Some Results on
Characterization, Inference and Random Data Generation. Journal of Statistical
Theory and Applications, 12(1), pp.92-105.
}
\seealso{
\code{\link[bbmle]{mle2}}
}
