% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{EstMLEBetaBin}
\alias{EstMLEBetaBin}
\title{Estimating the shape parameters a and b for Beta-Binomial Distribution}
\usage{
EstMLEBetaBin(x,freq,a,b,...)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing as a.}

\item{b}{single value for shape parameter beta representing as b.}

\item{...}{mle2 function inputs except data and estimating parameter.}
}
\value{
\code{EstMLEBetaBin} here is used as a wrapper for the \code{mle2} function of \pkg{bbmle} package
therefore output is of class of mle2.
}
\description{
The functions will estimate the shape parameters using the maximum log likelihood method and
moment generating function method for the Beta-Binomial distribution when the binomial
random variables and corresponding frequencies are given.
}
\details{
\deqn{a,b > 0}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
 messages will be provided to go further.
}
\examples{
No.D.D <- 0:7        #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)   #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
estimate <- EstMLEBetaBin(No.D.D,Obs.fre.1,a=0.1,b=0.1)

bbmle::coef(estimate)   #extracting the parameters

#estimating the parameters using moment generating function methods
EstMGFBetaBin(No.D.D,Obs.fre.1)

}
\references{
\insertRef{young2008pooling}{fitODBOD}
\insertRef{trenkler1996continuous}{fitODBOD}
\insertRef{hughes1993using}{fitODBOD}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
