% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSurveys.R
\name{compareSurveys}
\alias{compareSurveys}
\alias{compare.surveys}
\alias{comp.survs}
\alias{compareSurveys.default}
\alias{compareSurveys.psData}
\alias{compareSurveys.psFit}
\title{Compare two surveys on the basis of their shape parameters}
\usage{
compareSurveys(x, ...)

\method{compareSurveys}{default}(
  x,
  y,
  xname = NULL,
  yname = NULL,
  alternative = c("two.sided", "less", "greater"),
  null.value = 0,
  print = TRUE,
  ...
)

\method{compareSurveys}{psData}(x, y, ...)

\method{compareSurveys}{psFit}(x, y, ...)

compare.surveys(x, ...)

comp.survs(x, ...)
}
\arguments{
\item{x}{either an object of class \code{psData}---see \code{\link{readData}}
or an object of class \code{psFit}---see \code{\link{fitDist}}.}

\item{y}{either an object of class \code{psData}---see \code{\link{readData}}
or an object of class \code{psFit}---see \code{\link{fitDist}}.}

\item{xname}{an optional name for the first survey object.}

\item{yname}{an optional name for the second survey object.}

\item{alternative}{one of \code{"two.sided"}, \code{"less"}, or \code{"greater"}, depending on the type of
hypothesis test you wish to carry out. These may be replaced by single letter (or more) abbreviations.}

\item{null.value}{the true value of the difference in the shape parameters under the null hypothesis.}

\item{print}{if \code{TRUE} then the function will print summary output to the screen. This lets output be suppressed
in situations where the user wants the function to run silently.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
The function returns a \code{list} of class \code{"htest"} with the following elements:
\describe{
 \item{\code{statistic}}{ -- the test statistic.}
 \item{\code{p.value}}{ -- the P-value associated with the estimate.}
 \item{\code{estimate}}{ -- the estimated difference in the shape parameters.}
 \item{\code{null.value}}{ -- the specified hypothesized value of the difference in shape parameters---\code{0} by default.}
 \item{\code{stderr}}{ -- the standard error of the difference.}
 \item{\code{alternative}}{ -- a character string describing the alternative hypothesis.}
 \item{\code{method}}{ -- a character string describing the method.}
 \item{\code{data.name}}{ -- a character string with the names of the two input data sets separated by " and ".}
}
}
\description{
Compare two surveys on the basis of their shape parameters
}
\details{
This function **only** works for the zeta distribution. It does not work for the zero-inflated zeta distribution. If
the results from fitting ZIZ models are passed to this function, then it will ignore the zero-inflated part and simply refit a zeta model.

There is very little reason for \code{null.value} to be set to be anything other than \code{0}. However it has been included for flexibility.

\code{alternative = "greater"} is the alternative that x has a larger shape parameter than y.
\code{alternative = "less"} is the alternative that x has a smaller shape parameter than y.
}
\section{Methods (by class)}{
\itemize{
\item \code{compareSurveys(default)}: Compare two surveys on the basis of their shape parameters

\item \code{compareSurveys(psData)}: Compare two surveys on the basis of their shape parameters

\item \code{compareSurveys(psFit)}: Compare two surveys on the basis of their shape parameters

}}
\section{Functions}{
\itemize{
\item \code{compare.surveys()}: Compare two surveys on the basis of their shape parameters

\item \code{comp.survs()}: Compare two surveys on the basis of their shape parameters

}}
\examples{
data(Psurveys)
lau = Psurveys$lau
jackson = Psurveys$jackson
compareSurveys(lau, jackson)

## Example with fitted objects - note the function just refits the models
fit.lau = fitDist(lau)
fit.jackson = fitDist(jackson)
compareSurveys(fit.lau, fit.jackson)

## Example with a bigger difference
compareSurveys(Psurveys$roux, lau)

}
