% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDist.R
\name{fitDist}
\alias{fitDist}
\alias{fitdist}
\title{Fit a Zeta Distribution to Forensic Data}
\usage{
fitDist(x, nterms = 10, start = 1, ...)

fitdist(x, nterms = 10, start = 1, ...)
}
\arguments{
\item{x}{an object of type \code{psData}, usually obtained from
\code{\link{readData}}.}

\item{nterms}{the number of terms to compute the probability distribution
for.}

\item{start}{a starting value for the optimiser.}

\item{...}{other parameters - not currently used.}
}
\value{
an object of class \code{psFit}--see Details.
}
\description{
This function uses maximum likelihood estimation (MLE) to estimate the shape
parameter of  a zeta distribution from a set of observed counts for either
the number of groups/sources of forensically interesting material (mostly
glass or paint) recovered from clothing, or the number of fragments/particles
in each group. This, in turn, allows the estimation of the P and S
probabilities, as described by Evett and Buckleton (1990), which used in
computing the likelihood ratio (LR) for activity level propositions. The data
itself arises from clothing surveys. The general method is described in
Coulson et al. (2001), although poor typesetting, and a lack of definition of
terms makes it hard to see. This package improves on the estimation in that
linear interpolation is not required, and standard numerical optimisation is
used instead. The zeta distribution has probability mass function \deqn{p(k)
= \frac{k^{-s}}{\zeta(s)}}{p(k) = k^-s/zeta(s)} where \eqn{\zeta(s)}{zeta(s)}
is the Reimann Zeta function. Coulson et al. (2001) did not have an easy way
to rapidly compute this quantity, hence their use of linear interpolation.
}
\details{
The function returns an object of class \code{psFit} which is a
  \code{list} contains four elements:
\describe{
\item{\code{psData}}{ -- an object of class \code{psData}--see \code{\link{readData}},}
\item{\code{fit}}{ -- the fitted object from \code{\link[stats]{optim}},}
\item{\code{shape}}{ -- the maximum likelihood estimate of the shape parameter,}
\item{\code{var.shape}}{ - the maximum likelihood estimate of the shape parameter,}
\item{\code{fitted}}{ - a named \code{vector} containing the first \code{nterms of
the fitted distribution.}}
\item{\code{model}}{ - set to \code{"zeta"} for this model}
}.
The output can be used in a variety of ways. If the interest is just in the
shape parameter estimate, then the \code{shape} member of the \code{psFit}
object contains this information. It is also displayed along with a number
of fitted probabilities by the \code{\link{print.psFit}} method. The fitted
object can also be plotted using the plot method \code{\link{plot.psFit}},
and to create a probability function with \code{\link{probfun}}. **NOTE**
The value of the shape parameter that is printed (if you print the fitted
object) is different from that value that is stored in \code{shape}. The
stored value is for the \pkg{VGAM} parameterisation of the Zeta
distribution which uses \eqn{s^\prime = s - 1}{s' = s - 1}. Therefore the
printed value is \eqn{s = s^\prime + 1}{s = s' + 1}. If you intend to use
the fitted value with \code{\link[VGAM]{dzeta}}, then you should use the
stored value \eqn{s^\prime}{s'}.

If \code{start} is not specified, then it is chosen randomly from (0.5, 1).
The reason the lower value is not zero is that small starting values seem
to cause instability in the likelihood. If you specify your own starting
value, it would be sensible to keep it above 0.5.
}
\section{Functions}{
\itemize{
\item \code{fitdist()}: Fit a Zeta Distribution to Forensic Data
export

}}
\examples{
p = readData(system.file("extdata", "p.xlsx", package = "fitPS"))
fit = fitDist(p)
fit
}
\references{
Coulson, S. A., Buckleton, J. S., Gummer, A. B., and Triggs,
  C.M., "Glass on clothing and shoes of members of the general population and
  people suspected of breaking crimes", Science & Justice 2001: 41(1):
  39--48.

  Evett, I. W. and Buckleton, J. S., "The interpretation of glass evidence. A
  practical approach", Journal of the Forensic Science Society 1990: 30(4):
  215--223.
}
\seealso{
\code{\link{plot.psFit}}, \code{\link{print.psFit}},
  \code{\link{probfun}}.
}
