% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-ladder.R
\name{fetch_ladder}
\alias{fetch_ladder}
\alias{fetch_ladder_afl}
\alias{fetch_ladder_afltables}
\alias{fetch_ladder_squiggle}
\title{Fetch Ladder}
\usage{
fetch_ladder(
  season = NULL,
  round_number = NULL,
  comp = "AFLM",
  source = "AFL",
  ...
)

fetch_ladder_afl(season = NULL, round_number = NULL, comp = "AFLM")

fetch_ladder_afltables(
  season = NULL,
  round_number = NULL,
  match_results_df = NULL
)

fetch_ladder_squiggle(season = NULL, round_number = NULL)
}
\arguments{
\item{season}{Season in YYYY format, defaults to NULL which returns the year
corresponding the \code{Sys.Date()}}

\item{round_number}{Round number, defaults to NULL which returns latest round}

\item{comp}{One of "AFLM" (default), "AFLW", "VFL", "VFLW", "WAFL", "U18B" or "U18G." Not all data sources will have non-AFL data}

\item{source}{One of "AFL" (default), "footywire", "fryzigg", "afltables", "squiggle"}

\item{...}{Optional parameters passed onto various functions depending on source.}

\item{match_results_df}{(optional) A dataframe from \code{\link[=fetch_results_afltables]{fetch_results_afltables()}}, provide this to prevent having to download results again.}
}
\value{
A Tibble with the ladder from the relevant \code{season} and \code{round}.
}
\description{
\code{fetch_ladder} returns the Ladder for a given AFL Round. Internally, it calls
a corresponding \verb{fetch_ladder_*} function that depends on the source given.
By default the source used will be the official AFL website.

\code{\link[=fetch_ladder_afl]{fetch_ladder_afl()}}, \code{\link[=fetch_ladder_afltables]{fetch_ladder_afltables()}}, \code{\link[=fetch_ladder_squiggle]{fetch_ladder_squiggle()}}
can be called directly and return data from AFL website, AFL Tables and
Squiggle, respectively.
}
\examples{
\dontrun{
# Return data from AFL Website
fetch_ladder(2020, round = 1)

# This is equivalent to
fetch_ladder(2020, round = 1, source = "AFL")
fetch_ladder_afl(2020, round = 1)

# Return AFLW data
fetch_ladder(2020, round = 1, comp = "AFLW", source = "AFL")
fetch_ladder_afl(2020, round = 1, comp = "AFLW")

# Not all sources have AFLW data and will return a warning
fetch_ladder(2020, round = 1, comp = "AFLW", source = "afltables")
fetch_ladder(2020, round = 1, comp = "AFLW", source = "squiggle")

# Different sources
fetch_ladder(2015, round = 5, source = "afltables")
fetch_ladder(2015, round = 5, source = "squiggle")

# Directly call functions for each source
fetch_ladder_afl(2018, round = 9)
fetch_ladder_afltables(2018, round = 9)
fetch_ladder_squiggle(2018, round = 9)
}

}
\seealso{
\itemize{
\item \link{fetch_ladder_afl} for official AFL data.
\item \link{fetch_ladder_afltables} for AFL Tables data.
\item \link{fetch_ladder_squiggle} for Squiggle data.
}
}
\concept{fetch ladder functions}
