% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coeftable}
\alias{coeftable}
\alias{se}
\alias{pvalue}
\alias{tstat}
\title{Extracts the coefficients table from an estimation}
\usage{
coeftable(object, ...)

se(object, ...)

pvalue(object, ...)

tstat(object, ...)
}
\arguments{
\item{object}{An estimation (fitted model object), e.g. a \code{fixest} object.}

\item{...}{Other arguments to the methods.}
}
\value{
Returns a matrix (\code{coeftable}) or vectors.
}
\description{
Methods to extracts the coefficients table and its sub-components from an estimation.
}
\examples{

est = lm(mpg ~ cyl, mtcars)
coeftable(est)

}
\seealso{
Please look at the \code{\link{coeftable.fixest}} page for more detailed information.
}
