% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated_funs.R
\name{did_estimate_yearly_effects}
\alias{did_estimate_yearly_effects}
\title{Estimates yearly treatment effects}
\usage{
did_estimate_yearly_effects(
  fml,
  data,
  treat_time,
  reference,
  returnData = FALSE,
  ...,
  estfun = feols
)
}
\arguments{
\item{fml}{A formula containing the variables WITHOUT the yearly treatment effects (which will be added by this function).}

\item{data}{A \code{data.frame} containing all the variables.}

\item{treat_time}{Either a character vector of length two containing the name of the treatment variable and the name of the time variable (e.g. \code{c("treat", "year")}). Either a one-sided formula containing the treatment and the time (e.g. \code{~treat~year}).}

\item{reference}{The time period of reference. It should be a numeric scalar. The treatment will not be included for this time period so that it serves as reference.}

\item{returnData}{Logical, default is \code{FALSE}. If \code{TRUE}, then the original database with the yearly treatment variables is returned.}

\item{...}{Other arguments to be passed to \code{estfun}, the estimation function.}

\item{estfun}{The estimation function. Defaults to \code{\link[fixest]{feols}}.}
}
\value{
It returns an estimation object. In case of \code{fixest} estimations, it will return a \code{fixest} object.
}
\description{
This facility helps to estimate yearly treatment effects in a difference-in-difference setup without having to manually make the estimation. It is made as general as possible such that non-\code{fixest} estimation functions can also be used.
}
\details{
From \code{fixest} version 0.3.0 onwards, estimating yearly effects with a simple interaction of the type \code{var::year(ref)} in the formula is preferred (see details in \code{\link[fixest]{feols}}). You can then plot the yearly treatment with the function \code{\link[fixest]{coefplot}}. You have examples detailed in \code{\link[fixest]{coefplot}}.
}
\examples{

# Sample data illustrating the DiD
data(base_did)

# Estimation of yearly effect (they are automatically added)
est = did_estimate_yearly_effects(y ~ x1 + treat + post, base_did,
                                  treat_time = ~treat+period, reference = 5)

# Now we plot the results
did_plot_yearly_effects(est)

# Now with fixed-effects:
est_fe = did_estimate_yearly_effects(y ~ x1 | id + period, base_did,
                                     treat_time = ~treat+period, reference = 5)
did_plot_yearly_effects(est_fe)

# you can change the type of SE to be plotted:
did_plot_yearly_effects(est_fe, se = "cluster") # default
did_plot_yearly_effects(est_fe, se = "standard")


}
\seealso{
\code{\link{fixest-deprecated}}
}
\author{
Laurent Berge
}
\keyword{internal}
