% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table_remove.R
\name{remove_empty}
\alias{remove_empty}
\alias{remove_empty.pivot_table}
\title{Remove empty rows and columns from a pivot table}
\usage{
remove_empty(pt)

\method{remove_empty}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A \code{pivot_table} object.
}
\description{
Remove rows and columns without data from the pivot table represented by the
object.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

All rows and columns not belonging to the pivot table must be removed,
including those without data.
}
\examples{
library(tidyr)

pt <- pt_m4 \%>\% remove_empty()

pt <- pt_ine2871 \%>\% remove_empty()

}
\seealso{


Other pivot table definition functions: 
\code{\link{define_labels}()},
\code{\link{divide}()},
\code{\link{get_page}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{set_page}()},
\code{\link{view_table_attr}()}
}
\concept{pivot table definition functions}
