% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstate.R
\name{pmatrix.simfs}
\alias{pmatrix.simfs}
\title{Transition probability matrix from a fully-parametric, semi-Markov
multi-state model}
\usage{
pmatrix.simfs(x, trans, t = 1, newdata = NULL, ci = FALSE,
  tvar = "trans", tcovs = NULL, M = 1e+05, B = 1000, cl = 0.95)
}
\arguments{
\item{x}{A model fitted with \code{\link{flexsurvreg}}.  See
\code{\link{msfit.flexsurvreg}} for the required form of the model and the
data.  Additionally this should be semi-Markov, so that the time variable
represents the time since the last transition.  In other words the response
should be of the form \code{Surv(time,status)}. See the package vignette
for further explanation.

\code{x} can also be a list of models, with one component for each
permitted transition, as illustrated in \code{\link{msfit.flexsurvreg}}.}

\item{trans}{Matrix indicating allowed transitions.  See
\code{\link{msfit.flexsurvreg}}.}

\item{t}{Time to predict state occupancy probabilities for.  This must be a
single number, unlike \code{\link{pmatrix.fs}}.}

\item{newdata}{A data frame specifying the values of covariates in the
fitted model, other than the transition number.  See
\code{\link{msfit.flexsurvreg}}.}

\item{ci}{Return a confidence interval calculated by simulating from the
asymptotic normal distribution of the maximum likelihood estimates.  This
is turned off by default, since two levels of simulation are required.  If
turned on, users should adjust \code{B} and/or \code{M} until the results
reach the desired precision.  The simulation over \code{M} is generally
vectorised, therefore increasing \code{B} is usually more expensive than
increasing \code{M}.}

\item{tvar}{Variable in the data representing the transition type. Not
required if \code{x} is a list of models.}

\item{tcovs}{Predictable time-dependent covariates such as age, see
\code{\link{sim.fmsm}}.}

\item{M}{Number of individuals to simulate in order to approximate the
transition probabilities.  Users should adjust this to obtain the required
precision.}

\item{B}{Number of simulations from the normal asymptotic distribution used
to calculate variances.  Decrease for greater speed at the expense of
accuracy.}

\item{cl}{Width of symmetric confidence intervals, relative to 1.}
}
\value{
The transition probability matrix.  If \code{ci=TRUE}, there are
attributes \code{"lower"} and \code{"upper"} giving matrices of the
corresponding confidence limits.  These are formatted for printing but may
be extracted using \code{attr()}.
}
\description{
The transition probability matrix for semi-Markov multi-state models fitted
to time-to-event data with \code{\link{flexsurvreg}}.  This has \eqn{r,s}
entry giving the probability that an individual is in state \eqn{s} at time
\eqn{t}, given they are in state \eqn{r} at time \eqn{0}.
}
\details{
This is computed by simulating a large number of individuals \code{M} using
the maximum likelihood estimates of the fitted model and the function
\code{\link{sim.fmsm}}.  Therefore this requires a random sampling function
for the parametric survival model to be available: see the "Details"
section of \code{\link{sim.fmsm}}.  This will be available for all built-in
distributions, though users may need to write this for custom models.

Note the random sampling method for \code{flexsurvspline} models is
currently very inefficient, so that looping over the \code{M} individuals
will be very slow.

\code{\link{pmatrix.fs}} is a more efficient method based on solving the
Kolmogorov forward equation numerically, which requires the multi-state
model to be Markov.  No error or warning is given if running
\code{\link{pmatrix.simfs}} with a Markov model, but this is still invalid.
}
\examples{

# BOS example in vignette, and in msfit.flexsurvreg

bexp <- flexsurvreg(Surv(years, status) ~ trans, data=bosms3, dist="exp")
tmat <- rbind(c(NA,1,2),c(NA,NA,3),c(NA,NA,NA))

# more likely to be dead (state 3) as time moves on, or if start with
# BOS (state 2)

pmatrix.simfs(bexp, t=5, trans=tmat)
pmatrix.simfs(bexp, t=10, trans=tmat)

# these results should converge to those in help(pmatrix.fs), as M
# increases here and ODE solving precision increases there, since with
# an exponential distribution, the semi-Markov model is the same as the
# Markov model.
}
\author{
Christopher Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}.
}
\seealso{
\code{\link{pmatrix.fs}},\code{\link{sim.fmsm}},\code{\link{totlos.simfs}},
\code{\link{msfit.flexsurvreg}}.
}
\keyword{models,survival}

