% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{Survspline}
\alias{Survspline}
\alias{dsurvspline}
\alias{psurvspline}
\alias{qsurvspline}
\alias{rsurvspline}
\alias{hsurvspline}
\alias{Hsurvspline}
\alias{mean_survspline}
\alias{rmst_survspline}
\title{Royston/Parmar spline survival distribution}
\usage{
dsurvspline(
  x,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0,
  log = FALSE
)

psurvspline(
  q,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

qsurvspline(
  p,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

rsurvspline(
  n,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0
)

Hsurvspline(
  x,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0
)

hsurvspline(
  x,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0
)

rmst_survspline(
  t,
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0,
  start = 0
)

mean_survspline(
  gamma,
  beta = 0,
  X = 0,
  knots = c(-10, 10),
  scale = "hazard",
  timescale = "log",
  offset = 0
)
}
\arguments{
\item{x, q, t}{Vector of times.}

\item{gamma}{Parameters describing the baseline spline function, as
described in \code{\link{flexsurvspline}}.  This may be supplied as a
vector with number of elements equal to the length of \code{knots}, in
which case the parameters are common to all times.  Alternatively a matrix
may be supplied, with rows corresponding to different times, and columns
corresponding to \code{knots}.}

\item{beta}{Vector of covariate effects (deprecated).}

\item{X}{Matrix of covariate values (deprecated).}

\item{knots}{Locations of knots on the axis of log time, supplied in
increasing order.  Unlike in \code{\link{flexsurvspline}}, these include
the two boundary knots.  If there are no additional knots, the boundary
locations are not used.  If there are one or more additional knots, the
boundary knots should be at or beyond the minimum and maximum values of the
log times.  In \code{\link{flexsurvspline}} these are exactly at the
minimum and maximum values.

This may in principle be supplied as a matrix, in the same way as for
\code{gamma}, but in most applications the knots will be fixed.}

\item{scale}{\code{"hazard"}, \code{"odds"}, or \code{"normal"}, as
described in \code{\link{flexsurvspline}}.  With the default of no knots in
addition to the boundaries, this model reduces to the Weibull, log-logistic
and log-normal respectively.  The scale must be common to all times.}

\item{timescale}{\code{"log"} or \code{"identity"} as described in
\code{\link{flexsurvspline}}.}

\item{offset}{An extra constant to add to the linear predictor
\eqn{\eta}{eta}.}

\item{log, log.p}{Return log density or probability.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X
\le x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random numbers to simulate.}

\item{start}{Optional left-truncation time or times.  The returned
restricted mean survival will be conditioned on survival up to
this time.}
}
\value{
\code{dsurvspline} gives the density, \code{psurvspline} gives the
distribution function, \code{hsurvspline} gives the hazard and
\code{Hsurvspline} gives the cumulative hazard, as described in
\code{\link{flexsurvspline}}.

\code{qsurvspline} gives the quantile function, which is computed by crude
numerical inversion (using \code{\link{qgeneric}}).

\code{rsurvspline} generates random survival times by using
\code{qsurvspline} on a sample of uniform random numbers.  Due to the
numerical root-finding involved in \code{qsurvspline}, it is slow compared
to typical random number generation functions.
}
\description{
Probability density, distribution, quantile, random generation, hazard, 
cumulative hazard, mean and restricted mean functions for the Royston/Parmar
spline model.   These functions have all parameters of the distribution collecte together in a single argument \code{gamma}.  For the equivalent functions with one argument per parameter, see \code{\link{Survsplinek}}.
}
\examples{

## reduces to the weibull
regscale <- 0.786; cf <- 1.82
a <- 1/regscale; b <- exp(cf)
dweibull(1, shape=a, scale=b)
dsurvspline(1, gamma=c(log(1 / b^a), a)) # should be the same

## reduces to the log-normal
meanlog <- 1.52; sdlog <- 1.11
dlnorm(1, meanlog, sdlog) 
dsurvspline(1, gamma = c(-meanlog/sdlog, 1/sdlog), scale="normal")
# should be the same
}
\references{
Royston, P. and Parmar, M. (2002).  Flexible parametric
proportional-hazards and proportional-odds models for censored survival
data, with application to prognostic modelling and estimation of treatment
effects. Statistics in Medicine 21(1):2175-2197.
}
\seealso{
\code{\link{flexsurvspline}}.
}
\author{
Christopher Jackson <chris.jackson@mrc-bsu.cam.ac.uk>
}
\keyword{distribution}
