% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.flexsurvreg.R
\name{residuals.flexsurvreg}
\alias{residuals.flexsurvreg}
\title{Calculate residuals for flexible survival models}
\usage{
\method{residuals}{flexsurvreg}(object, type = "response", ...)
}
\arguments{
\item{object}{Output from \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}}, representing a fitted survival model object.}

\item{type}{Character string for the type of residual desired. Currently only \code{"response"} is supported. More residual types may become available in future versions.}

\item{...}{Not currently used.}
}
\value{
Numeric vector with the same length as \code{nobs(object)}.
}
\description{
Calculates residuals for \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}} model fits.
}
\details{
Residuals of \code{type = "response"} are calculated as the naive difference between the observed survival and the covariate-specific predicted mean survival from \code{\link{predict.flexsurvreg}}, ignoring whether the event time is observed or censored.
}
\examples{

fitg <- flexsurvreg(formula = Surv(futime, fustat) ~ age, data = ovarian, dist = "gengamma")
residuals(fitg)

}
\seealso{
\code{\link{predict.flexsurvreg}}
}
